<?php include 'header.php'; include '../api/db.php'; 

$date = date('Y-m-d');
$stmt = $conn->prepare("SELECT u.id, u.name, u.mobile, 
    (SELECT type FROM attendance WHERE user_id = u.id AND DATE(timestamp) = :date ORDER BY timestamp DESC LIMIT 1) as status,
    (SELECT timestamp FROM attendance WHERE user_id = u.id AND DATE(timestamp) = :date ORDER BY timestamp DESC LIMIT 1) as last_seen
    FROM users u WHERE u.role = 'staff'");
$stmt->bindParam(':date', $date);
$stmt->execute();
$staff = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>Dashboard <small class="text-muted fs-6"><?php echo $date; ?></small></h2>
<div class="row mt-4">
    <?php foreach($staff as $member): ?>
    <div class="col-md-4 mb-3">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><?php echo htmlspecialchars($member['name']); ?></h5>
                <p class="card-text">Mobile: <?php echo htmlspecialchars($member['mobile']); ?></p>
                <p class="card-text">
                    Status: 
                    <?php if($member['status'] == 'IN'): ?>
                        <span class="badge bg-success">Checked In</span>
                    <?php elseif($member['status'] == 'OUT'): ?>
                        <span class="badge bg-danger">Checked Out</span>
                    <?php else: ?>
                        <span class="badge bg-secondary">Not Marked</span>
                    <?php endif; ?>
                </p>
                <?php if($member['last_seen']): ?>
                    <p class="card-text"><small class="text-muted">Last Update: <?php echo $member['last_seen']; ?></small></p>
                <?php endif; ?>
                <a href="map_view.php?user_id=<?php echo $member['id']; ?>" class="btn btn-sm btn-outline-primary">View on Map</a>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</div>

</div></body></html>
