<?php include 'header.php'; include '../api/db.php'; 

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';

$users = $conn->query("SELECT id, name FROM users WHERE role = 'staff'")->fetchAll(PDO::FETCH_ASSOC);

$locations = [];
if($user_id) {
    $stmt = $conn->prepare("SELECT * FROM locations WHERE user_id = :user_id AND DATE(timestamp) = :date ORDER BY timestamp ASC");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->bindParam(':date', $date);
    $stmt->execute();
    $locations = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<h2>User Movement Map</h2>
<form class="row g-3 mb-4">
    <div class="col-auto">
        <input type="date" name="date" class="form-control" value="<?php echo $date; ?>">
    </div>
    <div class="col-auto">
        <select name="user_id" class="form-select" required>
            <option value="">Select User</option>
            <?php foreach($users as $u): ?>
                <option value="<?php echo $u['id']; ?>" <?php if($user_id == $u['id']) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($u['name']); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-auto">
        <button type="submit" class="btn btn-primary">View Track</button>
    </div>
</form>

<?php if($user_id && count($locations) > 0): ?>
    <div id="map" class="map-container"></div>
    <script>
        function initMap() {
            const path = [
                <?php foreach($locations as $loc): ?>
                { lat: <?php echo $loc['latitude']; ?>, lng: <?php echo $loc['longitude']; ?> },
                <?php endforeach; ?>
            ];

            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 14,
                center: path[0],
            });

            const flightPath = new google.maps.Polyline({
                path: path,
                geodesic: true,
                strokeColor: "#FF0000",
                strokeOpacity: 1.0,
                strokeWeight: 2,
            });

            flightPath.setMap(map);
            
            // Add markers for start and end
            new google.maps.Marker({ position: path[0], map: map, title: "Start" });
            new google.maps.Marker({ position: path[path.length - 1], map: map, title: "End" });
        }
    </script>
    <!-- Replace YOUR_API_KEY with actual key -->
    <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_API_KEY&callback=initMap&v=weekly" defer></script>
<?php elseif($user_id): ?>
    <div class="alert alert-warning">No location data found for this user on this date.</div>
<?php endif; ?>

</div></body></html>
