<?php
include 'db.php';

$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : null;
$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');

$sql = "SELECT a.*, u.name FROM attendance a JOIN users u ON a.user_id = u.id WHERE DATE(a.timestamp) = :date";
if($user_id) {
    $sql .= " AND a.user_id = :user_id";
}
$sql .= " ORDER BY a.timestamp DESC";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':date', $date);
if($user_id) {
    $stmt->bindParam(':user_id', $user_id);
}
$stmt->execute();
$attendance = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(["status" => "success", "data" => $attendance]);
?>
