<?php
include 'db.php';

$data = json_decode(file_get_contents("php://input"));

if(isset($data->user_id) && isset($data->type) && isset($data->latitude) && isset($data->longitude)) {
    $user_id = $data->user_id;
    $type = $data->type; // IN or OUT
    $latitude = $data->latitude;
    $longitude = $data->longitude;

    $stmt = $conn->prepare("INSERT INTO attendance (user_id, type, latitude, longitude) VALUES (:user_id, :type, :latitude, :longitude)");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->bindParam(':type', $type);
    $stmt->bindParam(':latitude', $latitude);
    $stmt->bindParam(':longitude', $longitude);

    if($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Attendance marked as $type"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to mark attendance"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Incomplete data"]);
}
?>
