<?php
include 'db.php';

$data = json_decode(file_get_contents("php://input"));

if(isset($data->user_id) && isset($data->latitude) && isset($data->longitude)) {
    $user_id = $data->user_id;
    $latitude = $data->latitude;
    $longitude = $data->longitude;

    $stmt = $conn->prepare("INSERT INTO locations (user_id, latitude, longitude) VALUES (:user_id, :latitude, :longitude)");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->bindParam(':latitude', $latitude);
    $stmt->bindParam(':longitude', $longitude);

    if($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Location updated"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to update location"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Incomplete data"]);
}
?>
