<?php include 'header.php'; include '../api/db.php'; 

$date = isset($_GET['date']) ? $_GET['date'] : date('Y-m-d');
$user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';

$sql = "SELECT a.*, u.name FROM attendance a JOIN users u ON a.user_id = u.id WHERE DATE(a.timestamp) = :date";
if($user_id) $sql .= " AND a.user_id = :user_id";
$sql .= " ORDER BY a.timestamp DESC";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':date', $date);
if($user_id) $stmt->bindParam(':user_id', $user_id);
$stmt->execute();
$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);

$users = $conn->query("SELECT id, name FROM users WHERE role = 'staff'")->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>Attendance Logs</h2>
<form class="row g-3 mb-4">
    <div class="col-auto">
        <input type="date" name="date" class="form-control" value="<?php echo $date; ?>">
    </div>
    <div class="col-auto">
        <select name="user_id" class="form-select">
            <option value="">All Users</option>
            <?php foreach($users as $u): ?>
                <option value="<?php echo $u['id']; ?>" <?php if($user_id == $u['id']) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($u['name']); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-auto">
        <button type="submit" class="btn btn-primary">Filter</button>
    </div>
</form>

<table class="table table-striped">
    <thead>
        <tr>
            <th>Name</th>
            <th>Type</th>
            <th>Time</th>
            <th>Location</th>
            <th>Map</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($logs as $log): ?>
        <tr>
            <td><?php echo htmlspecialchars($log['name']); ?></td>
            <td>
                <span class="badge bg-<?php echo $log['type'] == 'IN' ? 'success' : 'danger'; ?>">
                    <?php echo $log['type']; ?>
                </span>
            </td>
            <td><?php echo date('H:i:s', strtotime($log['timestamp'])); ?></td>
            <td><?php echo $log['latitude'] . ', ' . $log['longitude']; ?></td>
            <td>
                <a href="https://www.google.com/maps?q=<?php echo $log['latitude']; ?>,<?php echo $log['longitude']; ?>" target="_blank" class="btn btn-sm btn-link">View</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

</div></body></html>
